dofile("fer_Tools.lua")
dofile("GroundUnits/WeaponSystem/Tools/WeaponSystemTools.lua")
dofile("GroundUnits/WeaponSystem/Tools/LauncherTools.lua")
dofile("GroundUnits/WeaponSystem/Tools/TurretTools.lua")

dofile("GroundUnits/WeaponSystem/Tools/AutoGunSounds.lua")

local host = ED_AudioAPI.createHost(ED_AudioAPI.ContextWorld, "TPZ_WS")

-- turret

local TPZ_turret = {}

function TPZ_turret:calc_pitch_gain(rotationSpeedY)
	local rotSpdY = math.abs(rotationSpeedY)
	local pitch = 0.5 + rotSpdY
	local gain = ((rotSpdY > 1.0) and 1.0 or rotSpdY) + 0.8
	
	return pitch, gain
end

setmetatable(TPZ_turret, {__index = class_turret})

function onEvent_CreateTurret(arg1, arg2)
	local ws_type = arg1
	local ws_id = arg2
	
	local sound_file = TPZ_turret:select_sound_file(getWsType(ws_type))
	local sound_source = ED_AudioAPI.createSource(host, sound_file)
	
	local turret = TPZ_turret:new(getWsType(ws_type), sound_source)
	table.insert(turret_list, turret)
end

function onEvent_StopTurret(arg1)
	if turret_list[arg1] ~= nil then
		turret_list[arg1]:stop_play()
	end
end

-- turret

-- launcher

local TPZ_launcher = {}

-- machinegun_MG3
-- WS_ID:	1
-- L_ID:	1
-- L_TYPE:	2

function TPZ_launcher:select_launcher(ws_id, l_id)
	if ws_id == 1 and l_id == 1 then
		return machinegun_MG3
	end
end

setmetatable(TPZ_launcher, {__index = class_launcher})

function onEvent_CreateLauncher(arg1, arg2, arg3)
	local ws_id = arg1
	local l_id = arg2
	local l_type = getWsType(arg3)
	local launcher_param = TPZ_launcher:select_launcher(ws_id, l_id)
	
	local launcher = class_launcher:new(ws_id, l_id, l_type, launcher_param, host)
	TPZ_launcher:table_insert(launcher)
end

function onEvent_SingleShot(arg1, arg2)
	if launcher_list[arg1][arg2] ~= nil then
		TPZ_launcher:single_shot(arg1, arg2)
	end
end

function onEvent_StartBurst(arg1, arg2)
	if launcher_list[arg1][arg2] ~= nil then
		TPZ_launcher:start_burst(arg1, arg2)
	end
end

function onEvent_EndBurst(arg1, arg2)
	if launcher_list[arg1][arg2] ~= nil then
		TPZ_launcher:end_burst(arg1, arg2)
	end
end

function onEvent_ReloadFirst(arg1, arg2)
	if launcher_list[arg1][arg2] ~= nil then
		TPZ_launcher:reload_first(arg1, arg2)
	end
end

function onEvent_ReloadSecond(arg1, arg2)
	if launcher_list[arg1][arg2] ~= nil then
		TPZ_launcher:reload_second(arg1, arg2)
	end
end

-- launcher

-- maintain

function onUpdate(params)
	updateHost(host, params)
	
	if turret_list[params.WsId] ~= nil then
		turret_list[params.WsId]:update(params.RotationSpeedY)
	end
end

-- maintain